*------------------------------------------------------------------------------
* Copylock ST - Disk Protection System for the Atari ST/STE
*
* (c)1988-90 Rob Northen Computing, U.K. All Rights Reserved.
*
* Title  : keydisk.s
*
* Version: 2.12.89
*------------------------------------------------------------------------------

*------------------------------------------------------------------------------
*                              IMPORTANT NOTICE
*                              ----------------
*
*    DO NOT COPY THIS FILE OR ANY OTHER COPYLOCK FILE ONTO ANY KEY DISK
*
*              DO NOT REFORMAT ANY OF THE TRACKS ON THE KEY DISK
*
*                      DO TEST PROTECTED CODE THOROUGHLY
*
*------------------------------------------------------------------------------

*------------------------------------------------------------------------------
* Read the serial number from a Copylock ST key disk in floppy drive A or B
* on entry (user or supervisor mode),
*	d0.w = drive no. of key disk (0-7)
*	   0 = drive A, side 0
*	   1 = drive B, side 0
*	   2 = drive A, side 1
*	   3 = drive B, side 1
*
*          bit 2 of the drive no. controls whether only one drive is
*          examined for the key disk or both drives. If bit 2 is clear
*          only the drive specified in bits 0-1 of d0.w will be examined.
*          If bit 2 is set drive A and B are examined for a key disk.
*
*	d1.w = motor off flag, 0=turn motor off, 1=leave motor on
* on exit,
*	d0.l = serial no. 0=key disk not found
*	d1.w = drive no. key disk was found in
*
*	all other registers preserved
*
* Note:
*       The serial number can be read from side 1 of a key disk providing 
*       the drive used is double sided and the key disk has been copied on
*       both sides by the disk duplicator. If you use both sides of the
*       key disk you must write clearly on the disk label "DOUBLE SIDED
*       DISK".
*
*	Keydisk must not be called as a subroutine. No RTS is done at 
*	the end of the code (see example below).	
*
*	The serial number of the key disk can be found by running the
*       program SERIALNO.TOS.
*
*	The key disk is formatted as a double sided 80 track disk with
*       10 sectors per track. The boot sector is configured as a single
*       sided 10 sector disk for compatibility with single sided drives.
*       All 2*10*80 sectors may be used for reading and writing. 
*
* Example
*
* check_for_key_disk
*		moveq.l	#0,d0			drive A only
*		moveq.l	#0,d1			turn motor off
*		INCLUDE	keydisk.s
*		cmp.l	#serial_no,d0
*		bne.s	no_key_disk
*				
* no_key_disk
*		rts
*				
*------------------------------------------------------------------------------
keydisk
		dc.l $48E7E0E0,$487A0012,$2F3C0005,$00044E4D,$508F4CDF,$07074AFC,$48E7FFFF,$487A001A
		dc.l $23DF0000,$0010204F,$4E7A0002,$2F40003C,$08800000,$4E7B0002,$2E484CFA,$7FFF0002
		dc.l $2F3C4E73,$00002F3C,$00000010,$2F3C0004,$DDB92F3C,$BD96BDAE,$2F3CB386,$B5862F3C
		dc.l $D046D246,$2F3C0246,$A71F2F3C,$00023C17,$2F3C0004,$2C6F2F3C,$BD96BDAE,$23CF0000
		dc.l $0024007C,$A71F5CB9,$00000024,$7285712C,$2F186D85,$DA2C2F34,$6D858354,$2F2C0040
		dc.l $BE16FD7A,$6C402EB9,$2D3D996F,$2CB8B938,$C4492CB9,$BF934A5E,$6778E87E,$323C983C
		dc.l $27BF911E,$DBB92312,$0008614D,$4E7127F9,$C82AE6B1,$5942AE21,$0184557C,$EA5B90AF
		dc.l $9F0D5603,$03C4DF3C,$0B732F7C,$D6B22C6F,$D6B2B2A3,$03017B79,$FC425524,$0A012EB3
		dc.l $17400C82,$B7386932,$5D4034E4,$05806502,$DFB9DA0D,$00081D44,$4A03B360,$E6405DC2
		dc.l $A3462F7C,$05E1D246,$D5B7E2CD,$93804277,$0B020A74,$C01303C5,$DACB412D,$1C2C0843
		dc.l $BB88CB35,$15BF617F,$46375702,$406C6BAC,$CBBFC651,$9A8017C3,$8517F30C,$EC78D0E7
		dc.l $FC8A4102,$F443FFFF,$C243D0C3,$30FF9FF4,$1EC2FFFF,$8B836153,$30FF817B,$1FCBFFFF
		dc.l $179F007A,$30FF4F5F,$3FEBFFFF,$B583D0C3,$30FFDDD4,$1FC9FFFF,$F5336153,$30FFAB8B
		dc.l $1FCBFFFF,$0D0F007A,$30FF59EF,$3FEBFFFF,$80A2D0C3,$30FF05B7,$E03CFFFF,$27DC5043
		dc.l $30FFF85A,$51B2FFFF,$1D1F9EB2,$30FFD99D,$A26DF33F,$CB6BD0D3,$CB6B000C,$3C0C1253
		dc.l $1FE77BC9,$39107D7C,$39100024,$980219FD,$0359CBD9,$5130E510,$9C62FE49,$25AF1706
		dc.l $DE9ACFC5,$0150D86E,$0D6DF159,$0E891435,$18A62FF2,$E8A9AD2C,$01D02867,$E509F284
		dc.l $FCB63CA2,$1411CCE7,$4252E61C,$80C03039,$9917F01A,$3975F6B9,$99EF0FE9,$5B7D1A06
		dc.l $7448EE1F,$0F08F8B2,$CA5A118F,$592570C2,$724C835C,$BA67E217,$D3931189,$59B6CCDA
		dc.l $72D358CB,$8C3B8E36,$C77658AF,$30D371DB,$C9B0E1B8,$1D29FCA9,$3656015C,$D18C0C59
		dc.l $7687DA7D,$86BE0DD9,$A2981FE2,$45F6EBFF,$5D49271D,$5808BFAC,$FE65273F,$0982BF1A
		dc.l $5B9F4B37,$768A964B,$A7276672,$322A8069,$AD7B99C6,$7998B163,$ACF53CEE,$39EC9837
		dc.l $53376254,$6F1EAC71,$880D25A0,$5EDCDC62,$79090921,$8426278A,$AEB9430B,$349EA3C6
		dc.l $82FA4311,$0A8FAC6E,$23B90ACB,$C31D9670,$2C7AAF98,$AAD7372D,$F66CA00B,$0F943668
		dc.l $D757B1BC,$F07F5BA6,$59DC74CB,$F9B97204,$2AA39CDB,$40B235C4,$592484DD,$7237A1A3
		dc.l $19A8BADD,$D6471538,$10ADD197,$35BF48B6,$C1DC6153,$4AF97A02,$96786CD9,$31A98622
		dc.l $AEFA4ADC,$16796409,$E5F9A81E,$61383EB7,$7D7D57EC,$8EC4F327,$5801EF6C,$71273CDD
		dc.l $ED38EA35,$DC54656E,$F567B18C,$0C46ACD5,$D5DE71B2,$60957529,$8A5A8E70,$C54BA7AB
		dc.l $02545F97,$0C717A7C,$C5CE83B1,$10856328,$77CC7C5D,$844C807E,$AE819993,$39A2B2BC
		dc.l $19B68DB7,$CD2F28BA,$19B44217,$F4D7CC35,$0CC05754,$26178F07,$E1CBB064,$029D287D
		dc.l $1B421B7E,$9DC0B6B5,$490740D2,$606ACAEF,$79330630,$925D104D,$A9C84896,$C2717B95
		dc.l $44F7D68E,$5EA020AB,$7613E0CC,$E370F9E5,$00FB0402,$1A620421,$35431D48,$C658AA65
		dc.l $D0EC1703,$EA15157D,$B5BA0266,$CEE62FC2,$72425823,$7495C1C1,$8DBE3CBF,$FE9A55E3
		dc.l $EB4B6F06,$1E296823,$EF4A33C9,$EA49B31F,$3362FEB4,$D0F5192E,$7267F649,$BC850E52
		dc.l $4C8E5901,$9A45F422,$B3915327,$CC44D850,$3B49F1D8,$C89F3AF9,$41BF479E,$BCC4E372
		dc.l $2A1700FA,$C4FCE5C7,$61D00122,$BC12224A,$0701C481,$61DEDD55,$F413A8FB,$4CF0C2DB
		dc.l $D93BCD70,$5798E666,$C251627F,$DBEA517C,$5D7C8F65,$7735BC66,$F0A31478,$095C277B
		dc.l $8FCADCED,$C91BF690,$FA187010,$04358841,$5F6EA17E,$AB8BBBAB,$7DAA56C8,$A6B2FC9C
		dc.l $BFDBC5DB,$40236001,$594C34C6,$A5694DA9,$2DFA992D,$EF70654B,$F783BB61,$5FE02B7C
		dc.l $ABFD447B,$596F9FB6,$8D6E61D7,$998B84B6,$65A89DCF,$B1C5B6CE,$2F0C300F,$1CE2CBC9
		dc.l $C98A7CC8,$1D4D81EF,$AA569B18,$D12355B4,$5ABC8EA4,$F5F75827,$3314204C,$1E5FC699
		dc.l $837CDFC5,$EC99F8E9,$25B6020C,$B2EF1B35,$9098966E,$A9C6520A,$721FFDC0,$DD4111E9
		dc.l $5BA22B1C,$48A1A312,$A187BCC4,$3BBE25E0,$541F12FD,$ACFD2CD9,$373ED129,$EC2E5D47
		dc.l $FA47F859,$136F0276,$2C265E6F,$45CF6D6C,$C349E8B5,$DC9232D2,$F515BDCC,$0E3EB962
		dc.l $59352D79,$85BA47A2,$B2F99F31,$162FB85F,$1EE9425B,$ED24FEF9,$3F10776F,$58C6EC1F
		dc.l $A7C24A45,$C014D137,$3F17212D,$58BFBA59,$A7BD9498,$3F1C9161,$CB39AAB0,$46565BB8
		dc.l $C17776E9,$DA208602,$453D9F28,$83A6B8D1,$B0A53E57,$7AC257D0,$C5E370F9,$A5DFD42F
		dc.l $BF0DDCE9,$45092F22,$E3A6FCCD,$2FC415F0,$EA1ECF7B,$66C7E824,$55C46EA2,$F0DD871B
		dc.l $3AFAA060,$962BB986,$50802D51,$886146FA,$BB62C07C,$477FD9BF,$82A5F217,$34985FB4
		dc.l $4DC15D2B,$D8D4A948,$F1F527A6,$0BE19262,$3619C27F,$910ADBA9,$ADEF0B2C,$29133096
		dc.l $DA45D354,$836E0C71,$BDCA47B2,$D82FA6D7,$A206A4B4,$7B243BD1,$0513C2EA,$7A70D403
		dc.l $06DD6EEB,$DFF48BC1,$06FBBA01,$202A6B6B,$C3A0F494,$1CBE0CF0,$F7DB6E16,$16FF3A30
		dc.l $E61EF70D,$00F6EFCE,$3DDDF707,$E424103E,$01341563,$6B9424D5,$72269487,$DCF8AC79
		dc.l $740AB4AB,$FF5CF51D,$46EEB5CF,$12C03EC1,$2AD2D7F3,$5724C965,$5FB65B17,$0C88D509
		dc.l $259A7F3B,$72ECA1AD,$BC7E845F,$CA506F51,$6462AA83,$52B47DF5,$5D4631A7,$4C180D99
		dc.l $E72A59CB,$F67C5E3D,$420E62EF,$91E0AFE1,$ADF28D13,$5E444285,$6AD61837,$9BA85629
		dc.l $B8BA445B,$8A0C2ACD,$D79E517F,$69700071,$07827FA3,$79D41715,$88660EC7,$FB38AEB9
		dc.l $9A4A3EEB,$2D9C075D,$7D2E500F,$51006101,$71128233,$A564FBA5,$B5F61557,$6AC81749
		dc.l $8BDA497B,$E12CF3ED,$32BE5E9F,$4890D191,$EAA294C3,$E0F4F035,$F3862BE7,$EA588FD9
		dc.l $8D6A640B,$A4BCF07D,$F84E7D2F,$50205221,$7432B753,$2C84F4C5,$41165277,$79E81869
		dc.l $9EFA8E9B,$784CFD0D,$CDDEABBF,$67B0E2B1,$0DC2E9E3,$88140955,$9EA68907,$1978B0F9
		dc.l $C08AC92B,$5BDC199D,$B36EEA4F,$8F408341,$B7522C73,$F3A42DE5,$0C36CF97,$C9085989
		dc.l $F21A13BB,$4F6C462D,$A8FE38DF,$C6D033D1,$70E27F03,$6F346275,$89C62627,$88981219
		dc.l $33AA6E4B,$52FC82BD,$AE8E976F,$0E60F461,$3A72E193,$FAC4A705,$17568CB7,$5828DAA9
		dc.l $853AD8DB,$668CCF4D,$C41E05FF,$65F0C4F1,$14025423,$9654FB95,$B4E60347,$37B8B339
		dc.l $E6CA536B,$8A1C2BDD,$E9AE848F,$CD80A581,$FD92D6B3,$41E46025,$627689D7,$27489BC9
		dc.l $585ADDFB,$BDAC986D,$1F3E131F,$45109611,$F7226943,$FD74D4B5,$20062067,$26D89459
		dc.l $D9EA788B,$013C14FD,$64CEB1AF,$CCA096A1,$00B20BD3,$C9045945,$ED96C6F7,$36689CE9
		dc.l $6B7A231B,$54CCA18D,$BA5E603F,$6430A731,$1A4209E7,$AEDD5A44,$C876EA20,$E1EB253D
		dc.l $3F08DDA0,$58216493,$8EB61309,$A7DFCFB8,$12804FFE,$7B246927,$7DA16927,$0024929E
		dc.l $57224D2A,$52A1F051,$7D9D625E,$0775329D,$52A113DD,$2512625E,$B3A201BD,$52A11AE0
		dc.l $3273625E,$07D8602E,$52A18ABB,$241D625E,$0F292A64,$52A12FA2,$1B67625E,$BD246FBA
		dc.l $52A142D8,$AE57625E,$A80214E2,$52A103E2,$AE5D625E,$8AEA226C,$52A1A030,$1ABF625E
		dc.l $A9494D60,$52A16E1C,$7D21625E,$D8C8B28C,$52A1FC32,$7D8D625E,$43266EBD,$52A1AA36
		dc.l $35E7625E,$4CA4F0CC,$3C675816,$6F2AEE61,$06027D9D,$691E6D1A,$4D625BE1,$B4127D9D
		dc.l $652BA461,$62627D9D,$6EADC97A
		dc.w $4D46
		